﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.IO;

public class clsFileIO
{
    System.IO.BinaryReader mMyReader;
    System.IO.BinaryWriter mMyWriter;

	public clsFileIO()
	{
		//
		// TODO: Add constructor logic here
		//
	}

    public void OpenFileRead(string FileName)
    {
        string FilePath = System.AppDomain.CurrentDomain.BaseDirectory + "App_Data\\" + FileName;
        System.IO.FileStream MyFile = new System.IO.FileStream(FilePath, FileMode.Open, FileAccess.Read);
        mMyReader = new System.IO.BinaryReader(MyFile);
    }

    public void OpenFileWrite(string FileName)
    {
        string FilePath = System.AppDomain.CurrentDomain.BaseDirectory + "App_Data\\" + FileName;
        System.IO.FileStream MyFile = new System.IO.FileStream(FilePath, FileMode.Create, FileAccess.Write);
        mMyWriter = new System.IO.BinaryWriter(MyFile);
    }

    public Byte GetDecByte()
    {
        Byte MyByte;
        try
        {
            MyByte = mMyReader.ReadByte();
            return MyByte;
        }
        catch
        {
            return 0;
        }
    }

    public Int32 GetDecBytePair()
    {
        Int32 Byte1 = GetDecByte();
        Int32 Byte2 = GetDecByte();
        return 256 * Convert.ToInt32(Byte1) + Byte2;    
    }

    public string HetHXByte()
    {
        Byte MyByte;
        clsBaseConvert BaseConvert = new clsBaseConvert();
        //        Try
        try
        {
            MyByte = mMyReader.ReadByte();
            return BaseConvert.DecToHex(MyByte);
        }
        catch
        {
            return "00";
        }
    }

    public void WriteByte(Byte DecByte)
    {
        mMyWriter.Write(DecByte);
    }

    public void Close()
    {
        mMyWriter.Close();
    }

    public void WriteBytes(List<Byte> Bytes)
    {
        Int32 Count = 0;
        while (Count < Bytes.Count)
        {
            WriteByte(Bytes[Count]);
            Count++;
        }
    }

    public string ReadTextFile(string FileNameAndPath)
    {
        string Script = "";
        //open a connection to the text file on disc
        System.IO.StreamReader AFile = new System.IO.StreamReader(FileNameAndPath);
        //var to store a single line of the script
        string ALine;
        //while there are items still to process
        while (AFile.Peek() != -1)
        {
            //read in a line of text
            ALine = AFile.ReadLine();
            //concatenate the line to the variable Script including a carrage return and line feed
            Script = Script + ALine + Environment.NewLine;
        }
        //close the text file
        AFile.Close();
        //return the script
        return Script;
    }


    public List<string> GetDirectoryContents(string FilePath)
    {
        List<string> FileNames = new List<string>();
        System.IO.DirectoryInfo dDir = new System.IO.DirectoryInfo(FilePath);

        foreach (System.IO.FileSystemInfo fFileSystemInfo in dDir.GetFiles())
        {
            if (fFileSystemInfo.Extension == ".txt")
            {
                FileNames.Add(fFileSystemInfo.Name);
            }
        }
        return FileNames;
    }
}








